	function H = PZ_2_FREQ_S(G, Z, P, W)
		
	% Computes the frequency response for an analog filter significantly 
	% more accurate than the standard MATLAB routine freqs.
	
	% Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Oscar Gustafsson 
	% Modified by: 		LW, 2003-09-18
	% Copyright:		by authors - not released for commercial use
	% Version: 			1
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	H = G*ones(1,length(W));
	W = i*W;
	for n = 1:length(Z)
		H = H.*(W - Z(n));    
	end
	for n = 1:length(P)
		H = H./(W - P(n));    
	end
